
rm(list=ls())
library(dplyr)
library(Synth)

change.countries = c("Algeria", "Bangladesh", "Bhutan", "Burundi", "Cape Verde",
                     "Comoros", "Djibouti", "Fiji", "Gabon", "Ghana",
                     "Guinea", "Guinea Bissau", "Guyana", "Ivory Coast", "Kenya", "Lesotho", "Madagascar",
                     "Malawi", "Mali", "Mozambique", "Nepal", "Niger", "Nigeria", "Pakistan",
                     "Peru", "Senegal", "Sierra Leone", "Tunisia", "Zambia", "Zimbabwe")

dat = read.csv("RAS.csv", header=TRUE)

dat$country = as.character(dat$country)

dat = dat[dat$country %in% c(change.countries,"Indonesia"), c("country", "ctyid", "year",
              "state", "social", "legislation")]

width=3200
height=2400
res = 300
time = 1990:2014

##############################################################
# Delete Incomplete Countries
##############################################################

num.missing <- function(x) {
  return (sum(is.na(x)))
}

dat.temp = dat
out = aggregate(x=dat.temp, by=list(country=dat.temp$country), FUN=num.missing)

has.missing = rowSums((out[,-1])) > 0
countries.without.missing = out$country[!has.missing]

dat = dat[dat$country %in% countries.without.missing,]

dat.change = dat[dat$country %in% change.countries,]
list.unique = c(unique(dat.change$country), "Indonesia")


##############################################################
######### DRAW 
##############################################################

draw <- function(mat, x.range, ylim, ylab, time.v, text.x, text.y, text, all.mean, legend.lab) {
  plot(x.range, mat[nrow(mat),],
       type="l", ylim=ylim, 
       col=rgb(0,0,0,alpha=.7), lty="solid",
       ylab = ylab,
       xlab ="Year",
       lwd=6,
       axes = FALSE,
       cex.lab = 1.5
  )
  axis(side=1, at=seq(time[1], time[length(time)], 2))
  axis(side=2, at=seq(ylim[1], ylim[2], 5))
  
  abline(v=time.v, lty="dotted")
  text(text.x, text.y, text, cex=1.4)
  
  for (i in 1:(nrow(mat)-1)) {
    lines(x.range, mat[i,], lwd=1.2, lty="dashed")  
  }
  
  lines(x.range, all.mean, lwd=6, lty="dashed", col=rgb(0,0,0,alpha=.7))
  
  legend(x="bottomright",
         legend=legend.lab,
         lty=c("solid","dashed"),col=c("black","black"),
         cex=1.4,bg="white",lwd=c(2,2))
}




##############################################################
# state
##############################################################

dependent = "state"

mat = matrix(NA, nrow=length(list.unique), ncol=length(time))


for (i in 1:length(list.unique)) {
    mat[i,] = dat[dat$country==list.unique[i] ,dependent]
}

all.mean = colMeans(mat[1:(nrow(mat)-1), ])

png(filename = "Figure A5.1. State Discrimination in Indonesia and Other Democratising Countries.png", width=width, height=height, res=res)
    draw(mat, 
         x.range = time, 
         ylim = c(0,max(dat[,dependent])+5), 
         ylab = "State Discrimination of Religious Minorities",
         time.v = 1998, 
         text.x = 1998, 
         text.y = 10, 
         text = "",
         all.mean = all.mean,
         legend.lab = c("Indonesia","Mean of Democratising Countries"))
dev.off()



##############################################################
# legislation
##############################################################

dependent = "legislation"

mat = matrix(NA, nrow=length(list.unique), ncol=length(time))


for (i in 1:length(list.unique)) {
  mat[i,] = dat[dat$country==list.unique[i] ,dependent]
}

all.mean = colMeans(mat[1:(nrow(mat)-1), ])

png(filename = "Figure A5.2. Religious Legislation in Indonesia and Other Democratising Countries.png", width=width, height=height, res=res)
draw(mat, 
     x.range = time, 
     ylim = c(0,max(dat[,dependent])+5), 
     ylab = "Legislation of Religion",
     time.v = 1998, 
     text.x = 1998, 
     text.y = 10, 
     text = "",
     all.mean = all.mean,
     legend.lab = c("Indonesia","Mean of Democratising Countries"))
dev.off()



##############################################################
# social
##############################################################

dependent = "social"

mat = matrix(NA, nrow=length(list.unique), ncol=length(time))


for (i in 1:length(list.unique)) {
  mat[i,] = dat[dat$country==list.unique[i] ,dependent]
}

all.mean = colMeans(mat[1:(nrow(mat)-1), ])

png(filename = "Figure A5.3. Social Discrimination in Indonesia and Other Democratising Countries.png", width=width, height=height, res=res)
draw(mat, 
     x.range = time, 
     ylim = c(0,max(dat[,dependent])+5), 
     ylab = "Social Discrimination of Religious Minorities",
     time.v = 1998, 
     text.x = 1998, 
     text.y = 10, 
     text = "",
     all.mean = all.mean,
     legend.lab = c("Indonesia","Mean of Democratising Countries"))
dev.off()
